package ga.view.streaming.showroom;

import ga.view.config.AbstractSettings;

/**
 * This contains settings for a show room like materials, dimensions, type and
 * lighting type.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class ShowRoomSettings extends AbstractSettings {
  public static final String TYPE = "type";
  public static final String BOX_WIDTH = "width";
  public static final String BOX_HEIGHT = "height";
  public static final String BOX_LENGTH = "length";
  public static final String FLOOR_MATERIAL = "floorMaterial";
  public static final String CEILING_MATERIAL = "ceilingMaterial";
  public static final String WALL_MATERIAL = "wallMaterial";

  public static final String LIGHTING_TYPE = "LightingType";

  /**
   * Type of the show room. Only BOX is currently supported.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public enum ShowRoomType {
    BOX, LINE
  }

  /**
   * Gets the type of the showroom.
   * 
   * @return the type
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public ShowRoomType getType() {
    return get(TYPE);
  }
}
